
float computePhaseFactor(float x, float g)
{
    float gg = g * g;
    return (gg * -0.25 + 0.25) * pow(-2.0 * (g * x) + (gg + 1.0), -1.5) / PI;
}

float shadowFunc_no_shadow(float diffuseSun, float sssAmount, vec3 p3, vec2 lightmap, float ao, vec3 fragpos)
{
    float angleFactor = dot(normalize(p3), lightPos);

    float phase0 = computePhaseFactor(angleFactor, 0.75);
    float phase1 = computePhaseFactor(angleFactor, 0.5);
    float phase2 = computePhaseFactor(angleFactor, 0.1);
    float phase = max(max(phase0, phase1), phase2);

    float sss = clamp(phase * 3.14 * 1.5 * ao, 0.0, 1.0);
    sss *= sssAmount * 1;
    float lmpow = pow(lightmap.y, 24);

    float shadeDir = diffuseSun + sss;
    shadeDir *= lmpow;

    return shadeDir;
}
